    
    /**
     * @Author: hiVooby, Game Development
     * @Date:   2018-01-01 15:24:39
     * @Email: developer@hivooby.com
     * @Last Modified time: 2018-04-01 00:24:22
     */

MG.barrierQueue = (function () {
    var mBarrierQueue = [];
    var mRootNode;

    var mFirstBarrierIndex = 0;

    return {
        init: function (rootNode) {
            mRootNode = rootNode;
        },

        update: function (dt) {
            var i;

            for (i = mFirstBarrierIndex; i < mBarrierQueue.length; i++) {
                mBarrierQueue[i].update(dt);
            }
        },

        updateDOM: function (missileX, missileY, missileOffset) {
            var i;

            while (mFirstBarrierIndex > 0) {
                mBarrierQueue[0].destroy();
                mBarrierQueue.shift();
                mFirstBarrierIndex --;
            }

            for (i = 0; i < mBarrierQueue.length; i++) {
                var barrier = mBarrierQueue[i];

                if (!barrier.isInitialised()) {
                    barrier.init();

                    if (i > 0) {
                        mRootNode.insertBefore(barrier.getRootNode(), mBarrierQueue[i-1].getRootNode());
                    } else {
                        mRootNode.appendChild(barrier.getRootNode());
                    }
                }
            }

            var z = 0.0;
            for (i = 0; i < mBarrierQueue.length; i++) {
                mBarrierQueue[i].updateDOM(missileX, missileY, z + missileOffset);
                z += MG.BARRIER_SPACING;
            }
        },

        pushBarrier: function (type) {

            var barrier = new MG.Barrier(type);
            mBarrierQueue[mBarrierQueue.length] = barrier;

        },

        popBarrier: function () {
            mFirstBarrierIndex++;
            mFirstBarrierIndex = Math.min(mFirstBarrierIndex, mBarrierQueue.length);
        },

        nextBarrier: function () {
            return mBarrierQueue[mFirstBarrierIndex];
        },

        reset: function () {
            while (mFirstBarrierIndex < mBarrierQueue.length) {
                this.popBarrier();
            }
        },

        isEmpty: function () {
            return this.nextBarrier() === undefined;
        },

        numBarriers: function () {
            return mBarrierQueue.length - mFirstBarrierIndex;
        }
    };
}());



